%This function analysis the input component of vectors, 
%and try to find the number of different vectors and what are they 
%A map from the original vector to the ouput one is also provided,
%
% [ndiff,map,x1_diff,x2_diff,x3_diff]=countDiffVector(x1,x2,x3,min_dis)

function [ndiff,map,x1_diff,x2_diff,x3_diff]=countDiffVector(minDiffDist,x1,x2,x3)

%check the dimensions of input
ndim=nargin-1;
%get the length of the vector
nx=length(x1);
if nx==1
   ndiff=1;map=1;x1_diff=x1;
   if ndim>1
      x2_diff=x2;
      if ndim>3
         x3_diff=x3;
      end
   end
   return
end

[m,~]=size(x1); 
if m==1
   x1=x1';
   if ndim>1
      x2=x2';
      if ndim>2
         x3=x3';
      end
   end
end

if ndim==1
    x=x1;
elseif ndim==2; 
    x=[x1';x2'];
else
    x=[x1';x2';x3'];
end

%allocata the memory for stoing the temping different vectors
x_temp=zeros(size(x));
map=zeros(nx,1);

ndiff=1; 
x_temp(:,ndiff)=x(:,1);map(ndiff)=1;

for i=2:nx
    isnew=zeros(ndiff,1);   
    for j=1:ndiff
        if any( abs( (x(:,i)-x_temp(:,j))) >minDiffDist )==1
           isnew(j)=1;
        end
    end
    if all(isnew==1)==1    
        ndiff=ndiff+1;
        x_temp(:,ndiff)=x(:,i);
        map(i)=ndiff;
    else
        map(i)=find(isnew==0);
    end
%     map(i)=ndiff;
end
    

x1_diff=x_temp(1,1:ndiff);
if ndim>1
    x2_diff=x_temp(2,1:ndiff);
    if ndim>2
        x3_diff=x_temp(3,1:ndiff);
    end
end

end