function [x1,res0]=lsm2d(b,s,sx,sz,gx,gz,dx,dt,w,ttt,x0,maxnit,ls_method)
%Least square solutions
%
% [x, r] = lsl2(A, b, x0, options)

[nt,~]=size(b);

% % get the illumation
% [nz,nx]=size(s);
% illum=illumination(sx,sz,gx,gz,nx,nz,dx,dx);

res0=zeros(1,maxnit);
tic;              % Start your watches!

gk=zeros(size(x0));dk=zeros(size(x0));
for it=1:maxnit
%    display(['Iteration ',num2str(it),' Starts']);
    if (it==1)
        data=forward(x0,s,sx,sz,gx,gz,dx,dt,nt,w,ttt);
        data_res = data - b;
    else
        data=forward(x1,s,sx,sz,gx,gz,dx,dt,nt,w,ttt);
        data_res = data - b;
    end
    res0(it)=sum(data_res(:).^2);
%    display(['Data residual = ',num2str(res0(it)),', ',num2str(res0(it)/res0(1)*100),'%']);
    gk1 = migration(data_res,s,sx,sz,gx,gz,dx,dt,nt,w,ttt);
%     gk1 = gk1 .* illum; %illumination compensation; 
    dk1 = conjugate_direction(gk,gk1,dk,it,ls_method);
    % exact line search
    data=forward(dk1,s,sx,sz,gx,gz,dx,dt,nt,w,ttt);
    alpha = analytical_step_length(gk1, dk1, data, ls_method);
%    display(['analytical step length = ',num2str(alpha)]);
    x1 = x0 - alpha * dk1;
    % refresh 
    x0 = x1; gk = gk1; dk = dk1;
end

end

function dk1=conjugate_direction(gk,gk1,dk,it,ls_method)

if strcmp(ls_method,'SD')==1
   dk1=gk1;
elseif strcmp(ls_method,'CG')==1
   if it==1
      dk1=gk1;
   else
      a=sum(sum((gk1-gk).*gk1));
      b=sum(sum(gk.^2));
      dk1=gk1+a/b*dk;
   end
else
   error('Wrong ls_method chosen'); 
end

end

function alpha=analytical_step_length(gk1,dk1,data,ls_method)

if strcmp(ls_method,'SD')==1
   a=sum(gk1(:).^2);b=sum(data(:).^2); 
   alpha=a/b;
elseif strcmp(ls_method,'CG')==1
   a=sum(gk1(:).*dk1(:));b=sum(data(:).^2);alpha=a/b;
   %alpha=sum(gk1(:).*dk1(:))/sum(data(:).^2);
else
   error('Wrong least-squares method chosen!');
end

end
   
