function pos=max_loc(D_in)
%  Copyright (C) 2010 Center for Subsurface Imaging and Fluid Modeling (CSIM),
%  King Abdullah University of Science and Technology, All rights reserved.
%
%  author:   Xin Wang
%  email:    xin.wang@kaust.edu.sa
%  date:     Sep 26, 2012
%
%  max_loc: get the location of the maximum 
%
%  pos=max_loc(d)
%
%  IN   D_in : input data, can be any dimension
%
%  OUT  pos  : position of the maximum point 
%
%  Example 1: 1 Dimensional vector
%
%    x=[0,1,3,2,5] 
%    max_loc(x)
%
%  Example 2: 3 Dimensional matrix
%    x=rand(3,1,4)
%    max_loc(x)
%
%  See also min_loc

dim=size(D_in);
pos=max_loc_1d(D_in(:));
[pos1,pos2,pos3,pos4,pos5,pos6]=ind2sub(size(D_in),pos);
pos=[pos1,pos2,pos3,pos4,pos5,pos6];
pos=pos(1:length(dim));

if length(dim)==2 && min(dim)==1
    pos=max(pos);
end
    
end

function pos=max_loc_1d(D_in)

[n1,n2]=size(D_in);
n=max(n1,n2);

a=max(abs(D_in(:)))+1000.0;a=-a;
pos=0;
for i=1:n
    if D_in(i)>a
       a=D_in(i);
       pos=i;
    end
end

end