function mig=migration(data,s,sx,sz,gx,gz,dx,dt,nt,w,ttt)

[nz,nx]=size(s); dz=dx;
nconvolv=nt+length(w)+1;
wft=fft(w,nconvolv);
ntrace=length(sx); % get the number of receiver

minDiffDist=0.5;
x=[sx,gx];z=[sz,gz];
[ndiff,map,x_diff,z_diff]=countDiffVector(minDiffDist,x,z);

DistAll=zeros(nz,nx,ndiff);
OblqAll=zeros(nz,nx,ndiff);
TTTAll=zeros(nz,nx,ndiff); 

X=(0:nx-1)*dx;Z=(0:nz-1)*dz;[XX,ZZ]=meshgrid(X,Z);

for is=1:ndiff
    DistAll(:,:,is)=dist_cal(x_diff(is),z_diff(is),XX,ZZ);
    OblqAll(:,:,is)=oblq_cal(z_diff(is),ZZ,DistAll(:,:,is));
    if nargin==10
       TTTAll(:,:,is)=eikonal2d(s,x_diff(is),z_diff(is),nx,nz,dx,dz);
    else
       TTTAll(:,:,is)=ttt(:,:,round( x_diff(is)/dx )+1); 
    end
end

mig=zeros(nz,nx);
for itrace=1:ntrace
    Dist_s=DistAll(:,:,map(itrace));
    Oblq_s=OblqAll(:,:,map(itrace));
    Dist_g=DistAll(:,:,map(itrace+ntrace));
    Oblq_g=OblqAll(:,:,map(itrace+ntrace));
    tts=TTTAll(:,:,map(itrace));
    ttg=TTTAll(:,:,map(itrace+ntrace));
        
    trace=data(:,itrace);
    trace=deconvolv_source(trace,nt,wft,nconvolv);

    it=round((tts+ttg)/dt)+1;        
    for ix=1:nx
        for iz=1:nz
            if it(iz,ix)>0 && it(iz,ix)<=nt
                mig(iz,ix) ...
               =mig(iz,ix) ...
               +trace(it(iz,ix))*Oblq_s(iz,ix)*Oblq_g(iz,ix)...
                                /Dist_s(iz,ix)/Dist_g(iz,ix);
            end
        end
    end
end

end