function plot_get_wavelet(data,wavelet,t1,t2,g1,g2,shift_max)

nt=length(wavelet);
data_work=data(t1:t2,g1:g2);
wavelet=wavelet/max(abs(wavelet));
figure;set(gcf,'position',[100,100,800,300]);
subplot(131);wiggle(data_work);title('picked working area');
subplot(132);plot(wavelet,0:(nt-1),'-ob');
title('picked wavelet');set(gca,'Ydir','reverse');
subplot(133);hold on;title('check the wavelet');
for ig=1:(g2-g1+1)
    trace0=data_work(:,ig)/max(abs(data_work(:,ig)));
    plot(trace0+(ig-1),(0:(nt-1)),'-k');
    trace1=shift_wavelet(trace0,wavelet,shift_max);
    plot(trace1+(ig-1),(0:(nt-1)),'-b');
end
set(gca,'Ydir','reverse');axis([-1 11 0 40]);
hold off;
end

function trace1_shift=shift_wavelet(trace0,trace1,shift_max)

nt=length(trace0);
        
trace_xcorr=xcorr(trace0,trace1);
imax=max_loc(trace_xcorr);
        
n_shift=imax-nt;
trace1_shift=zeros(size(trace0));
if abs(n_shift)<shift_max && n_shift~=0
    n1=max(1,1+(n_shift)); 
    n2=min(nt,nt+(n_shift));
    n=n2-n1+1; 
    if n_shift>0
        trace1_shift(n1:n2)=trace1(1:n);
    else        
        trace1_shift(1:n)=trace1(nt-n+1:end);
    end
elseif n_shift==0
    trace1_shift=trace1;         
end
end
