function plot_km(mig0,mig1,mig2,dx)

[nz,nx]=size(mig0);

mig0_new=zeros(size(mig0));
mig0_new(1:nz-10,:)=mig0(11:end,:);

z=(0:nz-1)*dx;x=(0:nx-1)*dx;
figure;colormap(gray);
set(gcf,'position',[100,100,600,600]);
subplot(311);imagesc_norm(x,z,mig0_new);caxis([-1 1]);
title('KM without wavelet decon');
xlabel('X (m)'); ylabel('Z (m)');
subplot(312);imagesc_norm(x,z,mig1);caxis([-1 1]);
title('KM with decon of airgun wavelt');
xlabel('X (m)'); ylabel('Z (m)');
subplot(313);imagesc_norm(x,z,mig2);caxis([-1 1]);
title('KM with decon of ricker wavelt');
xlabel('X (m)'); ylabel('Z (m)');
end

function imagesc_norm(a,b,c)
if nargin == 1 % readin a vector
   imagesc(a/max(abs(a(:))));
elseif nargin ==3 
   imagesc(a,b,c/max(abs(c(:)))); 
end

end