function plot_lsm(mig1,res1,mig2,res2,dx)

[nz,nx]=size(mig1);

z=(0:nz-1)*dx;x=(0:nx-1)*dx;
figure;colormap(gray);
set(gcf,'position',[100,100,800,600]);
subplot(221);imagesc_norm(x,z,mig1);caxis([-1 1]);
title('LSM with airgun wavelet');
xlabel('X (m)'); ylabel('Z (m)');
subplot(222);plot_norm(res1);
title('Convergence rate');axis([1 length(res1) 0 1]);
xlabel('Iteration #'); ylabel('Normalized data residual');
subplot(223);imagesc_norm(x,z,mig2);caxis([-1 1]);
title('LSM with ricker wavelt');
xlabel('X (m)'); ylabel('Z (m)');
subplot(224);plot_norm(res2);
title('Convergence rate');axis([1 length(res1) 0 1]);
xlabel('Iteration #'); ylabel('Normalized data residual');

end

function imagesc_norm(a,b,c)

if nargin == 1 % readin a vector
   imagesc(a/max(abs(a(:))));
elseif nargin ==3 
   imagesc(a,b,c/max(abs(c(:)))); 
end

end

function plot_norm(a,b,c)
if nargin == 1 % readin a vector
   plot(a/max(abs(a(:))));
elseif nargin ==3 
   Plot(a,b,c/max(abs(c(:)))); 
end
end