%% Wavelet Lab
%
% Name: Michael Jordan
%
% Date: Jan 22, 1988

%% Why wavelet is important

% load airgun wavelet
load airgunwavelet.mat;
% load ricker wavelet
load rickerwavelet.mat;

% display wavelet;
plot_wavelet(airgunwavelet, dt_airgun,rickerwavelet,dt_ricker);

%% Modeling data of Sincline model with constant velocity

% Define model
load vel.mat; slowness=1.0./vel;
load refl.mat; %refl(:)=0.0;refl(26,51)=1.0;
% Display model;
plot_model(vel,refl,dx);

% Define the acquisition geometry (Zero Offset in this case)
[nz,nx]=size(vel);sx=(0:nx-1)*dx;sz=zeros(size(sx));gx=sx;gz=sz;
% Calculate the traveltime table for constant velocity model;
ttt=ttt_const2d(vel,dx,dx,sx,sz);
% Modeling the data
nt=801; 
data=forward(refl,slowness,sx,sz,gx,gz,dx,dt_airgun,nt,airgunwavelet,ttt);
% Display data
plot_data(data,dt_airgun);

%% Compare KM image without decon the wavelet and decon with airgun and ricket wavelet

% KM without decon the wavelet
mig_km=km(data,slowness,sx,sz,gx,gz,dx,dt_airgun,nt,ttt);
% KM with the true airgun wavelet decon
mig_km_airgun=migration(data,slowness,sx,sz,gx,gz,dx,dt_airgun,nt,airgunwavelet,ttt);
% KM with the ricker wavelet decon
mig_km_ricker=migration(data,slowness,sx,sz,gx,gz,dx,dt_ricker,nt,rickerwavelet,ttt);
% Display KM images
plot_km(mig_km,mig_km_airgun,mig_km_ricker,dx);

%% Compare LSM image with airgun and ricker wavelet

% Define the LSM parameters
% Initial model
refl0 = zeros(size(refl));
% Optimization method
ls_method = 'CG';
% max iteration number
maxnit = 100;

% LSM with the true airgun wavelet
[mig_lsm_airgun,res_airgun]=lsm2d(data,slowness,sx,sz,gx,gz,dx,dt_airgun,...
    airgunwavelet,ttt,refl0,maxnit,ls_method);
[mig_lsm_ricker,res_ricker]=lsm2d(data,slowness,sx,sz,gx,gz,dx,dt_ricker,...
    rickerwavelet,ttt,refl0,maxnit,ls_method);
% Display LSM imagess
plot_lsm(mig_lsm_airgun,res_airgun,mig_lsm_ricker,res_ricker,dx);

%% How to get wavelet

load Data_COG.mat
plot_COG(data,dt);

% find a small working area to calculate the wavelet
% the rectangle function use the top left point position to define the box
x=172; y=0.59; w=11; h=0.08;
rectangle('position', [x y w h]);
t1=round(y/dt)+1; t2=round((y+h)/dt); g1=x+1; g2=x+w;shift_max=5; 
wavelet=get_wavelet(data,t1,t2,g1,g2,shift_max);
plot_get_wavelet(data,wavelet,t1,t2,g1,g2,shift_max);

