module apps2d_wq_ssp

 use datatype
 use io
 use math
 use mmi_mpi
 use parser
 use wq_utilities_atten_ssp

 implicit none

 type(param),       private              :: par
 type(acquisition), private              :: coord
 logical,           private              :: store_boundary, message
 integer,           private              :: ix,iz,it,isx,isz,igx,igz,is,ig,i1,i2,&
                                            is1,is2,iter,is_pre

 real,              private              :: d1,d2,res_shot,res_process,gg,dgg,factor

 integer,           private, allocatable :: fs(:), izwb(:)

 real,              private, allocatable :: s(:),c(:,:),energy_temp(:,:),energy(:,:),mig_temp(:,:),mig(:,:),                   &
                                            gk(:,:),gk_old(:,:),g(:,:),g_old(:,:),d(:,:),taper(:),mig_sum(:,:),energy_sum(:,:),&
                                            gk_process(:,:),gk_shot(:,:),energy_process(:,:),energy_shot(:,:),slow(:,:),       &
                                            qf(:,:),den(:,:),tau(:,:),tausigma(:,:),tauepsilon(:,:)


 contains

!-------------------------------
subroutine wq_atten_ssp(parfile)

 use modeling
 use pml
 use source

 character(len=*), intent(in) :: parfile
 character(len=256)           :: file_name

 call start_mpi

 !! Read input parameters
 !! ---------------------
 call readparamfile(parfile, par)

 !! PML setting
 !! -----------
 call init_pml(par%nx, par%nz, par%npml)

 !! Read acquisition geometry data
 !! ------------------------------
 call readcoordfile(par%coordfile, coord)

 !! Memory allocations
 !! ------------------
 allocate(s(par%nt),fs(nx_pml))
 allocate(c(nz_pml,nx_pml))
 allocate(tau(nz_pml,nx_pml),tausigma(nz_pml,nx_pml),tauepsilon(nz_pml,nx_pml))
 allocate(qf(nz_pml,nx_pml),den(nz_pml,nx_pml))
 allocate(energy(nz_pml,nx_pml))
 allocate(gk(nz_pml,nx_pml))
 allocate(gk_process(nz_pml,nx_pml),gk_shot(nz_pml,nx_pml))
 allocate(energy_process(nz_pml,nx_pml),energy_shot(nz_pml,nx_pml))
 allocate(g(par%nz,par%nx),g_old(par%nz,par%nx),d(par%nz,par%nx))

 !$omp parallel do private(ix,iz)
 do ix=1,par%nx
 do iz=1,par%nz
    g(iz,ix)=0.0
    g_old(iz,ix)=0.0
    d(iz,ix)=0.0
 enddo
 enddo
 !$omp end parallel do

 !! Set up free surface
 !! -------------------
 call free_surface(par,fs,npml)

 !! Read velocity model
 !! -------------------
 call readvelfile(par,c,npml,nx_pml,nz_pml)

 !! Determine minimum velocity
 !! --------------------------
 par%cmin=min_value(c(iz1:iz2,ix1:ix2),par%nz,par%nx)
 par%cmax=max_value(c(iz1:iz2,ix1:ix2),par%nz,par%nx)

 !! Read Q model
 !! ------------
 call readqualfile(par,qf,npml,nx_pml,nz_pml)

 !! Determine maximum and minimum Q
 !! -------------------------------
 par%qmin=min_value(qf(iz1:iz2,ix1:ix2),par%nz,par%nx)
 par%qmax=max_value(qf(iz1:iz2,ix1:ix2),par%nz,par%nx)

 !! Density
 !! -------
 !$omp parallel do private(ix,iz)
 do ix=1,nx_pml
 do iz=1,nz_pml
    den(iz,ix)=1.0
 enddo
 enddo
 !$omp end parallel do

 !! Set up stress and strain relaxation parameters
 !! ----------------------------------------------
 !$omp parallel do private(ix,iz)
 do ix=1,nx_pml
 do iz=1,nz_pml
    tausigma(iz,ix)=(sqrt(1.0+1.0/qf(iz,ix)/qf(iz,ix))-1.0/qf(iz,ix))/(2.0*pi*par%f)
    tauepsilon(iz,ix)=1.0/(2.0*pi*par%f)/(2.0*pi*par%f)/tausigma(iz,ix)
    tau(iz,ix)=tauepsilon(iz,ix)/tausigma(iz,ix)-1.0
 enddo
 enddo
 !$omp end parallel do

 !! Read input tau model
 !! --------------------
 if(par%input_tau.eq.1) then
    call readtaufile(par,tau,npml,nx_pml,nz_pml)
 else
    !$omp parallel do private(ix,iz)
    do ix=1,nx_pml
    do iz=1,nz_pml
        tau(iz,ix)=tauepsilon(iz,ix)/tausigma(iz,ix)-1.0
    enddo
    enddo
    !$omp end parallel do
 endif

 !! Setup PML damping coefficient
 !! -----------------------------
 call setup_pml(par%dx,par%cmin)

 if(rank.eq.0) then
    call write_binfile('damp_global.H@',damp_global,nz_pml,nx_pml)
    output=trim('damp_global.H')
    call writehead(output,n1=nz_pml,n2=nx_pml,d1=1.0,d2=1.0,o1=0.0,o2=0.0)
 endif

 !! Setup Ricker source wavelet
 !! ---------------------------
 call getsource(par,s)

 if(rank.eq.0) then
    write(*,*) 'npml: ',par%npml, 'nz_pml: ',nz_pml, 'nx_pml: ',nx_pml
    write(*,*) 'ns: ', coord%ns, 'ng: ',coord%ngmax
    write(*,*) "Minimum velocity in the input model:", par%cmin
    write(*,*) "Maximum velocity in the input model:", par%cmax
    write(*,*) "Minimum Q in the input model:", par%qmin
    write(*,*) "Maximum Q in the input model:", par%qmax
    write(*,*) "Minimum tau allowed in the output model:", par%tau_min
    write(*,*) "Maximum tau allowed in the output model:", par%tau_max
    if(par%input_tau.eq.1) then
        par%qmin=min_value(tau,nz_pml,nx_pml)
        par%qmax=max_value(tau,nz_pml,nx_pml)
        write(*,*) "Minimum tau in the input model:", par%qmin
        write(*,*) "Maximum tau in the input model:", par%qmax
    endif
    if (par%cmax*par%dt/par%dx > 0.6) then
        write(*,*) "Stability Condition Violated !!!"
        write(*,*) "Terminating the Program"
        call flush(6)
        goto 999
    else
        write(*,*) "Stability Condition Satisfied"
    endif
    call flush(6)

    if(par%method.eq.1) then
        write(*,*) "Using peak frequencies to find the frequency shift"
    else
        write(*,*) "Using centroid frequencies to find the frequency shift"
    endif
    
 endif

 call readParFile(parfile,'FIRST_SHOT',par%first_shot,1)
 call readParFile(parfile,'LAST_SHOT',par%last_shot,coord%ns)

 call MPI_BARRIER(MPI_COMM_WORLD,ierr)
 call get_assigned(par%first_shot,par%last_shot,is1,is2)

 if(rank.eq.0) then
    write(*,*) "Doing 2D WQ for SSP"
    call flush(6)
    file_name=trim(trim(par%logfile)//'.log')
    open(99,file=file_name)
 endif

 do iter=1,par%itermax

    par%iter=iter

    if(rank.eq.0) then
        write(6,*)
        write(6,'(a)') '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
        write(6,'(a,i0)') '           WQ SSP ITERATION ', par%iter
        write(6,'(a)') '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
        call flush(6)
     endif

    !$omp parallel do private(ix,iz)
    do ix=1,nx_pml
    do iz=1,nz_pml
        gk_process(iz,ix)=0.0
        energy_process(iz,ix)=0.0
        energy(iz,ix)=0.0
        gk(iz,ix)=0.0
    enddo
    enddo
    !$omp end parallel do

    if(rank.eq.0) write(*,*) "Computing the gradient ..."

    res_process=0.0
    par%res_new=0.0
    !! Compute the gradient for all the shots
    !! -------------------------------------- 
    do is=is1,is2,par%skipshot+1

        call compute_gradient_shot_wq_ssp(coord,par,is,nx_pml,nz_pml,fs,c,qf,den,s,damp_global, &
                                          tau,tausigma,tauepsilon,energy_shot,gk_shot,res_shot)

        !$omp parallel do private(ix,iz)
        do ix=1,nx_pml
        do iz=1,nz_pml
            gk_process(iz,ix)=gk_process(iz,ix)+gk_shot(iz,ix)
            energy_process(iz,ix)=energy_process(iz,ix)+energy_shot(iz,ix)
        enddo
        enddo
        !$omp end parallel do

        res_process=res_process+res_shot
    enddo       

    !! Reduce for all the shots
    !! ------------------------
    call MPI_BARRIER(MPI_COMM_WORLD,ierr)
    call MPI_Allreduce(res_process,par%res_new,1,MPI_REAL,MPI_SUM,MPI_COMM_WORLD,ierr)

    call MPI_BARRIER(MPI_COMM_WORLD,ierr)
    call MPI_Allreduce(gk_process,gk,nz_pml*nx_pml,MPI_REAL,MPI_SUM,MPI_COMM_WORLD,ierr)

    call MPI_BARRIER(MPI_COMM_WORLD,ierr)
    call MPI_Allreduce(energy_process,energy,nz_pml*nx_pml,MPI_REAL,MPI_SUM,MPI_COMM_WORLD,ierr)

    if(rank.eq.0) then
        write(*,*) 'Iter= ',par%iter,' Current Data Residual: ',par%res_new
        call flush(6)
        write(99,*) 'Iter= ',par%iter,' Current Data Residual: ',par%res_new
        call flush(99)
    endif

    !$omp parallel do private(ix,iz)
    do ix=1,par%nx    
    do iz=1,par%nz    
        g(iz,ix)=gk(par%npml+iz,par%npml+ix)
    enddo
    enddo
    !$omp end parallel do

    !! Precondition the gradient
    !! -------------------------
    if(par%pre.eq.1) then
        !$omp parallel do private(ix,iz)
        do ix=1,par%nx    
        do iz=1,par%nz    
            g(iz,ix)=g(iz,ix)/energy(par%npml+iz,par%npml+ix)
        enddo
        enddo
        !$omp end parallel do
    endif

    !!! Mask -ve values in the gradient
    !!! -------------------------------
    !!$omp parallel do private(ix,iz)
    !do ix=1,par%nx
    !do iz=1,par%nz
    !    if(g(iz,ix).lt.0.0) then
    !        g(iz,ix)=0.0
    !    endif
    !enddo
    !enddo
    !!$omp end parallel do

    !if(par%iter.le.5) then
        if (par%smoothgrad.gt.0)  then
            !if(mod(par%iter,5).eq.0) then
                !par%smoothgrad=par%smoothgrad-2
                !call smooth_2d_pad(g,par%nz,par%nx,par%smoothgrad)
                call smooth_2d_rect_filter(g,par%nz,par%nx,40,20)
                !call smooth_2d_rect_filter(g,par%nz,par%nx,5,5)
            !endif
            if(rank.eq.0) write(*,*) "par%smoothgrad:",par%smoothgrad
        endif
    !endif

    !! Scale the gradient
    !! ------------------
    factor=max_value(tau(iz1:iz2,ix1:ix2),par%nz,par%nx)/mean_abs(g,par%nz,par%nx)
    if(rank.eq.0) write(*,*) "factor:",factor
    !$omp parallel do private(ix,iz)
    do ix=1,par%nx
    do iz=1,par%nz
        g(iz,ix)=2.0*g(iz,ix)*factor
        !g(iz,ix)=g(iz,ix)*factor
    enddo
    enddo
    !$omp end parallel do

    !! Update the search direction using conjugate gradient (Check this later !!!)
    !! ---------------------------------------------------------------------------
    !call conjugate_gradient_fwi(par,g,g_old,d)
    !$omp parallel do private(ix,iz)
    do ix=1,par%nx
    do iz=1,par%nz
        d(iz,ix)=g(iz,ix)
    enddo
    enddo
    !$omp end parallel do

    !!if(par%iter.gt.1) then
    !!$omp parallel do private(ix,iz)
    !do ix=1,par%nx
    !do iz=1,par%nz
    !    if(d(iz,ix).lt.0.0) then
    !        d(iz,ix)=0.0
    !    endif
    !enddo
    !enddo
    !!$omp end parallel do
    !!endif

    !! Mask the gradient till the sea-bottom
    !! -------------------------------------
    !$omp parallel do private(ix,iz)
    do ix=1,par%nx
    do iz=1,13
        d(iz,ix)=0.0
    enddo
    enddo
    !$omp end parallel do

    !! Mask the gradient at the bottom of the model
    !! --------------------------------------------
    !$omp parallel do private(ix,iz)
    do ix=1,par%nx
    !do iz=70,par%nz
    do iz=120,par%nz
        d(iz,ix)=0.0
    enddo
    enddo
    !$omp end parallel do

    if(rank.eq.0) then
        call filename(output,trim(par%gradfile)//'_iter',iter,'.H@')
        call write_binfile(output,d,par%nz,par%nx)
        call filename(output,trim(par%gradfile)//'_iter',iter,'.H')
        call writehead(output,n1=par%nz,n2=par%nx,n3=1,d1=par%dx,d2=par%dx,d3=1.0,  &
                       o1=0.0,o2=0.0,o3=0.0)
    endif

    if(rank.eq.0) write(*,*) "Computing the step-length ..."

    !! Compute the step-length and update the slowness
    !! -----------------------------------------------
    call wq_step_length_atten_ssp(coord,par,is,nx_pml,nz_pml,fs,s,damp_global,tau,tausigma,tauepsilon,d,c,qf,den)

    if(rank.eq.0) then
        write(*,*) 'alpha= ',par%alpha_wq
        call flush(6)
        write(99,*) 'alpha= ',par%alpha_wq
        call flush(99)
    endif

    !! Update the old gradient 
    !! ------------------------
    !$omp parallel do private(ix,iz)
    do ix=1,par%nx
    do iz=1,par%nz
        g_old(iz,ix)=g(iz,ix)
    enddo
    enddo
    !$omp end parallel do

    !!! Update Q model
    !!! --------------
    !call update_q(par,nz_pml,nx_pml,tau,qf) 

    !!! Update tauepsilon and tausigma
    !!! ------------------------------
    !!$omp parallel do private(ix,iz)
    !do ix=1,nx_pml
    !do iz=1,nz_pml
    !    tausigma(iz,ix)=(sqrt(1.0+1.0/qf(iz,ix)/qf(iz,ix))-1.0/qf(iz,ix))/(2.0*pi*par%f)
    !    tauepsilon(iz,ix)=1.0/(2.0*pi*par%f)/(2.0*pi*par%f)/tausigma(iz,ix)
    !enddo
    !enddo
    !!$omp end parallel do

    !! Save the tomogram
    !! -----------------
    if(rank.eq.0) then
        call filename(output,par%velfile_out,iter,'.H@')
        call write_binfile(output,tau(par%npml+1:par%npml+par%nz,par%npml+1:par%npml+par%nx),par%nz,par%nx)
        !call write_binfile(output,qf(par%npml+1:par%npml+par%nz,par%npml+1:par%npml+par%nx),par%nz,par%nx)

        call filename(output,par%velfile_out,iter,'.H')
        call writehead(output,n1=par%nz,n2=par%nx,n3=1,d1=par%dx,d2=par%dx,d3=25.0,o1=0.0,o2=0.0,o3=0.0)
    endif

    call MPI_BARRIER(MPI_COMM_WORLD,ierr)

 enddo      !! End of iterations loop

 call MPI_Barrier(MPI_COMM_WORLD,ierr)

 if(rank.eq.0) close(99)    !! Close the log file

 999 continue
 deallocate(c,qf,den,s,fs,tau,tausigma,tauepsilon)
 deallocate(energy,gk,g,g_old,d)
 deallocate(gk_process,gk_shot,energy_process,energy_shot)

 call stop_mpi

end subroutine wq_atten_ssp
!--------------------------


end module apps2d_wq_ssp
