! module for defining data structures
!
module datatype

 type param

  !! Parameters required for most simulations
  !! -----------------------------------------
  integer            :: nx,ny,nz,nt,free_surface,skipshot,skiptrace,npml,first_shot,last_shot
  character(len=100) :: velfile,coordfile,fileformat,sourcefile,sourcetype,csg_in,  &
                        illumfile,qualfile,snapshot_file,strategy
  real               :: dx,dt,f,fmax,cmin,cmax,qmin,qmax,reflmin,reflmax

  !! Parameters required for LSRTM
  !! -----------------------------
  integer             :: highpass,ic
  double precision    :: alpha,beta,gama
  character(len=100)  :: migfile,migfile_shot,reflfile

  !! Parameters required for both LSRTM and FWI
  !! ------------------------------------------
  integer             :: itermax,mute_direct,pre,n_taper,ismarine,izwb,window_size,iter
  character(len=100)  :: gradfile,logfile,csg_out,waterbottomfile,residualfile

  !! Parameters required for FWI 
  !! ---------------------------
  integer             :: nsearch_max,line_search,normalize,smoothgrad,smoothvel,smooth
  real                :: vmin,vmax,step,alpha_fwi,res_new,vconstraint,beta_fwi,perc_grad
  character(len=100)  :: velfile_out,csg_out_res

  !! Parameters required for WQ
  !! --------------------------
  integer             :: smooth_tau, input_tau
  real                :: tau_min,tau_max,alpha_wq,tau_constraint,beta_wq
  character(len=100)  :: csg_mod,taufile

  !! Parameters for multisource modeling and migration
  !! -------------------------------------------------
  integer            :: max_delay,sg,ns_sg 
  character(len=100) :: encoding_codes,encoding_polarity

  !! Optional parameters
  !! -------------------
  integer            :: mute_data,method,exportwavefield,variable_density,nt_in,shift_wavefield,nt_out, &
                        lbfgs_start,lbfgs_end
  real               :: dt_out,dt_in,window,xmin,xmax,offset_min,offset_max 
  character(len=100) :: densityfile,topofile,velfile_bg,vpfile,vsfile,data


 end type param

 type acquisition
    integer              :: ns,ngmax
    integer, allocatable :: ng(:)
    real,    allocatable :: xs(:),zs(:),xg(:,:),zg(:,:),t(:,:)
 end type acquisition

 type acquisition3d
    integer              :: ns,ngmax
    integer, allocatable :: ng(:)
    real,    allocatable :: xs(:),ys(:),zs(:),xg(:,:),yg(:,:),zg(:,:),t(:,:)
 end type acquisition3d

 type wavelet_param
    character(len=100)   :: fileformat,inputprefix,outputprefix
    integer              :: ns,ng,nt,iref
    real                 :: dx,dt,ds,dg
 end type wavelet_param

 type boundary3d
    real, allocatable    :: top(:,:,:,:),bottom(:,:,:,:),left(:,:,:,:),right(:,:,:,:), &
                            front(:,:,:,:),back(:,:,:,:)
 end type boundary3d

 type boundary2d
    real, allocatable    :: top(:,:,:),bottom(:,:,:),left(:,:,:),right(:,:,:)
 end type boundary2d

end module datatype

