#!/bin/bash
#SBATCH -A k1046
#SBATCH -p workq	    # Specify  SLURM partition (queue) name

#SBATCH -o JOB.%j.out       # Specify File to which standard out will be written
#SBATCH -e JOB.%j.err       # Specify File to which standard err will be written

###SBATCH --exclusive          # Specify exclusive access to nodes nobody will interfere

#SBATCH -t 00:30:00     # Specify Runtime in D-HH:MM  , for e.g 24 hrs.
#SBATCH --nodes=25
#SBATCH --cpus-per-task=16
#SBATCH --ntasks-per-socket=1

date
export OMP_NUM_THREADS=16
export KMP_AFFINITY=scatter,verbose
time srun -n 50  --ntasks-per-node=2 --hint=nomultithread ../src/bin/mmi par=parfile_wq_ssp
date
