%% SSP model parameters

clear all;
close all;
clc;

nz=200; nx=801;
dz=15.0/1000; dx=dz;

% Relation between tau and Q

qf=10:0.01:250;
freq=15.0;

tausigma=(sqrt(1.0+1.0./qf.^2)-1.0./qf)./(2*pi*freq);
tauepsilon=1.0./((2*pi*freq)*(2*pi*freq)*tausigma);
tau=tauepsilon./tausigma-1;

figure;
set(gcf,'units','inches','position',[0 0 6 4],'PaperPositionMode','auto');
set(gca,'FontSize',12); 
plot(qf(1:20000),tau(1:20000)); grid on; axis tight;
xlabel('Q','FontSize',12);
ylabel('\tau','FontSize',12);
title('Relationship between Q and \tau','FontSize',14,'FontWeight','normal');

%% Read Tau tomogram 

tau_inv=ReadBin('tomograms/tau50.H@',nz,nx,'l');

x=0:dx:(nx-1)*dx; z=0:dx:(nz-1)*dx; np=45;
isPrint=true;fig_format='-depsc2';isShow=true;
fig_pos1=[0 0 9]; fig_pos2=[0 0 9];

% figure; 
% set(gcf,'units','inches','position',[fig_pos1 5.5],'PaperPositionMode','auto');
% imagesc(x,z,tau_inv); colorbar; colormap('jet');
% xlabel('X (m)','FontSize',12);
% ylabel('Z (m)','FontSize',12);
% title('\tau tomogram','FontSize',14);

%% Convert between tau and Q
clc;
q_inv=zeros(nz,nx);
for ix=1:nx
    for iz=1:nz
        tmp=tau_inv(iz,ix);
        %t=find(tau==tmp);
        t=find(abs(tau-tmp)<0.01);
        q_inv(iz,ix)=qf(t(1));
    end
end

%% 
x=0:dx:(nx-1)*dx; z=0:dx:(nz-1)*dx; np=45;
title_fs=14; label_fs=12; axis_fs=12; cbar_fs=12; ifig=1;
isPrint=true;fig_format='-depsc2';isShow=true;
fig_pos1=[0 0 4.5]; fig_pos2=[0 0 9];

fac=3;

vel=ReadBin('/home/duttag/Desktop/lsrtm/model/overthrust_2D_vp_nz200_nx801.H@',nz,nx,'l');
vel=vel./1000;
vel_smooth=ReadBin('/home/duttag/Desktop/lsrtm/model/overthrust_2D_vpsmooth_nz200_nx801.H@',nz,nx,'l');
vel_smooth=vel_smooth./1000;
qp=ReadBin('/home/duttag/Desktop/lsrtm/model/overthrust_2D_qp1_nz200_nx801.H@',nz,nx,'l');

figure(1);
set(gcf,'units','inches','position',[fig_pos1 fac],'PaperPositionMode','auto');
ximage(x,z,vel);colormap('jet'); colorbar;
h=colorbar; set(gca,'FontSize',12);
sm_title('(a) True Velocity Model',title_fs);
set(h,'YTick',[2.5 3.5 4.5 5.5])
text(13.0,-0.2,'km/s','FontSize',10);
sm_label('X (km)','Z (km)',label_fs);
sm_axis([4 8 12 16],[1 2 3],axis_fs);

% print -dpng /home/duttag/Desktop/WQ_lab/wq_files/true_vel.png

figure(2);
set(gcf,'units','inches','position',[fig_pos1 fac],'PaperPositionMode','auto');
imagesc(x,z,1./qp); colorbar; colormap('jet');
sm_label('X (km)','Z (km)',label_fs);
sm_axis([4 8 12 16],[1 2 3],axis_fs);
sm_title('(b) True Q Model',title_fs);
h=colorbar; set(gca,'FontSize',12);
set(h,'YTick',[0.01 0.02 0.03 0.04 0.05])
text(13.0,-0.2,'1/Q','FontSize',10);

% print -dpng /home/duttag/Desktop/WQ_lab/wq_files/true_q.png

qf_start=10000*ones(nz,nx);

figure(3);
set(gcf,'units','inches','position',[fig_pos1 fac],'PaperPositionMode','auto');
ximage(x,z,1./qf_start);colormap('jet'); colorbar;
% ximage(x,z,qf_start);colormap('jet'); colorbar;
h=colorbar; set(gca,'FontSize',12);
sm_title('(c) Starting Q Model',title_fs);
sm_label('X (km)','Z (km)',label_fs);
text(13.0,-0.2,'1/Q','FontSize',10);
sm_axis([4 8 12 16],[1 2 3],axis_fs);

% print -dpng /home/duttag/Desktop/WQ_lab/wq_files/starting_q.png


figure(4);
set(gcf,'units','inches','position',[fig_pos1 fac],'PaperPositionMode','auto');
% imagesc(x,z,q_inv); colorbar; colormap('jet');
imagesc(x,z,1./q_inv); colorbar; colormap('jet');
sm_label('X (km)','Z (km)',label_fs);
sm_axis([4 8 12 16],[1 2 3],axis_fs);
sm_title('(d) Inverted Q Model',title_fs)
h=colorbar; set(gca,'FontSize',12);
set(h,'YTick',[0.01 0.02 0.03 0.04 0.05])
text(13.0,-0.2,'1/Q','FontSize',10);

% print -dpng /home/duttag/Desktop/WQ_lab/wq_files/inverted_q.png

%%

clear all;
close all;
clc;

nz=200; nx=801;
tau=zeros(nz,nx);

writebin('/home/duttag/Desktop/lsrtm/model/tau_hom.H@',tau);