!! module for 2D applications including forward modeling, RTM and FWI

module apps2d_atten

 use a2d_atten
 use datatype
 use io
 use math
 use mmi_mpi
 use parser

 implicit none

 type(param),       private              :: par
 type(acquisition), private              :: coord
 logical,           private              :: store_boundary, message
 integer,           private              :: ix,iz,it,isx,isz,igx,igz,is,ig,i1,i2,&
                                            is1,is2,iter,nsearch,nsearch_max,is_pre
 real,              private              :: d1,d2
 integer,           private, allocatable :: fs(:), izwb(:)

 double precision                        :: res,gg

 !! Medium properties
 !! -----------------
 real,              private, allocatable :: c(:,:),den(:,:),qf(:,:)

 !! For modeling and migration
 !! --------------------------
 real,              private, allocatable :: s(:),seis_true(:,:),seis(:,:), &
                                            energy_temp(:,:),energy(:,:),mig_temp(:,:),mig(:,:), &
                                            mig_sum(:,:),energy_sum(:,:),taper(:),wave(:,:,:)

 contains

!-------------------------------------
subroutine q_forward_modeling(parfile)

 use modeling
 use pml
 use source

 character(len=*), intent(in) :: parfile

 call start_mpi

 !! Read input parameters
 !! ---------------------
 call readparamfile(parfile, par)

 !! PML setting
 !! -----------
 call init_pml(par%nx, par%nz, par%npml)

 !! Read acquisition geometry data
 !! ------------------------------
 call readcoordfile(par%coordfile, coord)

 !! Memory allocations
 !! ------------------
 allocate(s(par%nt),fs(nx_pml))
 allocate(c(nz_pml,nx_pml),qf(nz_pml,nx_pml),den(nz_pml,nx_pml))
 allocate(wave(par%nz,par%nx,par%nt))

 !! Set up free surface
 !! -------------------
 call free_surface(par, fs, npml)

 !! Read velocity model
 !! -------------------
 call readvelfile(par,c,npml,nx_pml,nz_pml)

 !! Determine maximum and minimum velocities
 !! ----------------------------------------
 par%cmin=min_value(c(iz1:iz2,ix1:ix2),par%nz,par%nx)
 par%cmax=max_value(c(iz1:iz2,ix1:ix2),par%nz,par%nx)

 !! Read Q model
 !! ------------
 call readqualfile(par,qf,npml,nx_pml,nz_pml)

 !! Determine maximum and minimum Q
 !! -------------------------------
 par%qmin=min_value(qf(iz1:iz2,ix1:ix2),par%nz,par%nx)
 par%qmax=max_value(qf(iz1:iz2,ix1:ix2),par%nz,par%nx)

 !! Density
 !! -------
 !do i2=1,nx_pml
 !do i1=1,nz_pml
 !   den(i1,i2)=0.23*v(i1,i2)**0.25
 !enddo
 !enddo
 den=1.0

 !! Setup Ricker source wavelet 
 !! ---------------------------
 call getsource(par,s)
 if(rank.eq.0) then
    call write_binfile('source.H@',s,par%nt)
    output=trim('source.H')
    call writehead(output,n1=par%nt,n2=1,n3=1,d1=par%dt,d2=1.0,d3=1.0,&
                   o1=0.0,o2=0.0,o3=0.0)
 endif

 if(rank.eq.0) then
        write(*,*) 'npml: ',par%npml, 'nz_pml: ',nz_pml, 'nx_pml: ',nx_pml
        write(*,*) 'ns: ', coord%ns, 'ng: ',coord%ngmax
        write(*,*) "Minimum Velocity in the input model:", par%cmin
        write(*,*) "Maximum Velocity in the input model:", par%cmax
        write(*,*) "Minimum Q in the input model:", par%qmin
        write(*,*) "Maximum Q in the input model:", par%qmax
        if (par%cmax*par%dt/par%dx > 0.6) then
                write(*,*) "Stability Condition Violated !!!"
                write(*,*) "Terminating the Program"
                call flush(6)
                goto 999 
        else 
                write(*,*) "Stability Condition Satisfied"
        endif

        if(par%dx > par%cmin/(par%f*10)) then
                write(*,*) "Dispersion Criteria Violated !!!"
                write(*,*) "Adjust the modeling parameters"
        else
                write(*,*) "Dispersion Criteria Satisfied"
        endif
        call flush(6)
 endif

 call readParFile(parfile,'FIRST_SHOT',par%first_shot,1)
 call readParFile(parfile,'LAST_SHOT',par%last_shot,coord%ns)

 call MPI_BARRIER(MPI_COMM_WORLD,ierr)
 call get_assigned(par%first_shot,par%last_shot,is1,is2)


 if(rank.eq.0) write(*,*) "Doing Q FD modeling"

 !! Process all the shots
 !! ---------------------
 do is=is1,is2,par%skipshot+1

    write(*,*) "Process ",rank," shot ", is
    call flush(6)
    allocate(seis_true(par%nt,coord%ng(is)))
    seis_true=0.0

    call atten_modeling(is,par,coord,s,c,den,fs,nx_pml,nz_pml,npml,qf,wave,seis_true)

    !! Save the outputs
    !! ----------------
    call filename(output,par%csg_out,is,'.H@')
    call write_binfile(output,seis_true(1:par%nt,1:coord%ng(is)),par%nt,coord%ng(is))
    call filename(output,par%csg_out,is,'.H')
    call writehead(output,n1=par%nt,n2=coord%ng(is),n3=1, &
                   d1=par%dt,d2=par%dx,d3=25.0,     &
                   o1=0.0,o2=0.0,o3=0.0)

    deallocate(seis_true)

 enddo

 999 continue
 deallocate(c,s,fs)
 deallocate(den,qf,wave)

 call stop_mpi

end subroutine q_forward_modeling
!--------------------------------

end module apps2d_atten

