! module for computing density from velocity
!
module modeling

implicit none

contains

subroutine compute_density(variable_density, c, den, nx, nz)

integer, intent(in)  :: nx, nz, variable_density
real,    intent(in)  :: c(:,:)
real,    intent(out) :: den(:,:)
integer              :: ix, iz
real                 :: alpha, beta

if (variable_density == 0) then
  den = 1.0
else
  do ix=1,nx
    do iz=1,nz
if (1==0) then
      if (c(iz,ix) <= 1500.0) then
        den(iz,ix) = 1.0
!      elseif (c(iz,ix) > 4700.0) then
!        den(iz,ix) = 2.16
      else
        den(iz,ix) = 2.557
      endif
endif
      !if (c(iz,ix) < 1550.0) then
      !  den(iz,ix) = 0.23*c(iz,ix)**0.21
      !elseif (c(iz,ix) >= 1550.0 .and. c(iz,ix) < 1700.0) then
      !  alpha = (c(iz,ix)-1550.0)/(1700.0-1550.0)
      !  beta = (1.0-alpha)*0.21 + alpha*0.25
      !  den(iz,ix) = 0.23*c(iz,ix)**beta
      !else
      !  den(iz,ix) = 0.23*c(iz,ix)**0.25
      !endif
if (1==0) then
      if (c(iz,ix) <= 1550.0) then
        den(iz,ix) = 1.0
      else
        !den(iz,ix) = 0.3*c(iz,ix)**0.25
        den(iz,ix) = 0.23*c(iz,ix)**0.25
      endif
endif
      den(iz,ix) = 0.23*c(iz,ix)**0.25
    enddo
  enddo
endif

end subroutine compute_density
!------------------------------------------------------------------------
subroutine compute_density_wb(variable_density, c, den, nx, nz, npml, izwb)

integer, intent(in)  :: nx, nz, variable_density, npml, izwb(:)
real,    intent(in)  :: c(:,:)
real,    intent(out) :: den(:,:)
integer              :: ix, iz, npml2
real                 :: alpha, beta, factor

factor = 0.35
!factor = 0.23
den = 1.0
npml2 = 2*npml
if (variable_density == 1) then
  do ix=1,npml
    do iz=izwb(1)+npml+1,nz
      den(iz,ix) = factor*c(iz,ix)**0.25
    enddo
  enddo
  do ix=npml+1,nx-npml
    do iz=izwb(ix-npml)+npml+1,nz
      den(iz,ix) = factor*c(iz,ix)**0.25
    enddo
  enddo
  do ix=nx-npml+1,nx
    do iz=izwb(nx-npml2)+npml+1,nz
      den(iz,ix) = factor*c(iz,ix)**0.25
    enddo
  enddo
endif

end subroutine compute_density_wb

end module modeling

