module wq_utilities_atten_ssp

 use global
 use string
 use math
 use string 
 use io
 use datatype
 use pml
 use mmi_mpi
 use a2d_atten
 use a2d_atten_wq

 implicit none

 include 'fftw3.f'

 real, private, allocatable    :: csg_obs(:,:),csg_calc(:,:),taper(:),slow_trial(:,:),csg_hilbert(:,:),wave(:,:,:)
 integer, private              :: ig,it,ix,iz,nsearch,snap_period,stat
 integer, private, allocatable :: izwb(:)
 real, private                 :: eps,step_min,gg,dgg,res_process,res,x2,y2,x3,y3, &
                                  res_min,res_shot,res_total,factor,c_old_min,c_old_max, &
                                  dt_snap

 !! Variables for Gauss-Newton FWI
 !! ------------------------------
 real, private, allocatable    :: gk_process(:,:),gk_shot(:,:),energy_process(:,:),energy_shot(:,:), &
                                  gk(:,:),gk1(:,:),dk(:,:),dk1(:,:),energy(:,:)
 double precision, private     :: res_process_lsm,res_shot_lsm,res_lsm,dgg_process,dgg_shot,dgg_lsm,gg_lsm

 !! Variables for WQ
 !! ----------------
 real,              allocatable  :: trace_obs(:),trace_calc(:),csg_mod(:,:),freq(:),delta_f(:),tau_trial(:,:), &
                                    delta_f_iter1(:),trace_obs_fft_abs(:),trace_calc_fft_abs(:)
 double complex,    allocatable  :: trace_obs_complex(:),trace_calc_complex(:), &
                                    trace_obs_fft(:),trace_calc_fft(:)
 integer*8                       :: plan
 real                            :: fpeak_obs_data,fpeak_calc_data,distance,t_shift
 integer,           dimension(1) :: indx_obs,indx_calc

 contains

!! -------------------------------------------------------------------------------------
subroutine compute_gradient_shot_wq_ssp(coord,par,is,nx_pml,nz_pml,fs,v,qf,den,s,damp, &
                                    tau,tausigma,tauepsilon,energy,gk,residual)

 type(acquisition), intent(in)   :: coord
 type(param),       intent(inout):: par
 integer,           intent(in)   :: is,nx_pml,nz_pml,fs(:)
 real,              intent(in)   :: v(:,:),qf(:,:),den(:,:),s(:),damp(:,:), &
                                    tau(:,:),tausigma(:,:),tauepsilon(:,:)
 real,              intent(out)  :: gk(nz_pml,nx_pml),energy(:,:)
 real,              intent(out)  :: residual

 integer                         :: ishift,tmp,isx,isz

 !! Initialize the output
 !! ---------------------
 residual=0.0

 !! Allocate and initialize the variables
 !! -------------------------------------
 allocate(wave(par%nz,par%nx,par%nt))
 allocate(csg_obs(par%nt,coord%ng(is)),csg_calc(par%nt,coord%ng(is)),csg_mod(par%nt,coord%ng(is)))
 allocate(trace_obs(par%nt),trace_calc(par%nt),trace_obs_complex(par%nt),trace_calc_complex(par%nt))
 if(par%method.eq.2) then
    allocate(trace_obs_fft_abs(par%nt/2+1),trace_calc_fft_abs(par%nt/2+1))
 endif
 allocate(trace_obs_fft(par%nt),trace_calc_fft(par%nt)) 
 allocate(freq(par%nt/2+1)); allocate(taper(par%n_taper))
 allocate(delta_f(coord%ng(is)),delta_f_iter1(coord%ng(is)))

 csg_obs=0.0;  csg_calc=0.0;  csg_mod=0.0; 
 trace_obs=0.0; trace_calc=0.0; freq=0.0
 if(par%method.eq.2) then
    trace_obs_fft_abs=0.0; trace_calc_fft_abs=0.0;
 endif
 trace_obs_complex=cmplx(0.0,0.0); trace_calc_complex=cmplx(0.0,0.0)
 trace_obs_fft=cmplx(0.0,0.0); trace_calc_fft=cmplx(0.0,0.0)
 delta_f=0.0; delta_f_iter1=0.0

 !! Set up frequency sampling
 !! -------------------------
 do it=1,par%nt/2+1
     freq(it)=(it-1)*1.0/par%dt/par%nt
 enddo

 !! Set up taper for muting the direct-arrivals
 !! -------------------------------------------
 par%n_taper=50
 call hanning(taper,par%n_taper)

 !! Generate predicted data
 !! ----------------------- 
 call atten_modeling_wq(is,par,coord,s,v,den,fs,nx_pml,nz_pml,npml,qf,&
                        tau,tausigma,tauepsilon,.true.,wave,csg_calc)

 !! Save predicted data
 !! -------------------
 call filename(output,par%csg_out,is,'_iter')
 call filename(output,output,par%iter,'.H@')
 call write_binfile(output,csg_calc,par%nt,coord%ng(is))

 !! Read observed data
 !! ------------------
 call filename(output,par%csg_in,is,'.H@')
 call read_binfile(output,csg_obs,par%nt,coord%ng(is))

 !! Mute all the events below the direct arrival
 !! --------------------------------------------
 isx=par%npml+int(coord%xs(is)/par%dx)+1
 isz=par%npml+int(coord%zs(is)/par%dx)+1

 do ig=1,coord%ng(is)

    !! Mute all the events below the direct arrival
    !! --------------------------------------------
    distance=(coord%xs(is)-coord%xg(is,ig))**2+(coord%zs(is)-coord%zg(is,ig))**2
    t_shift=sqrt(distance)/v(isz,isx) 
    ishift=int(t_shift/par%dt)
    tmp=par%n_taper
    do it=ishift+1,ishift+par%n_taper
        csg_obs(it,ig)=csg_obs(it,ig)*taper(tmp)
        csg_calc(it,ig)=csg_calc(it,ig)*taper(tmp)
        tmp=tmp-1
    enddo
    csg_obs(ishift+par%n_taper+1:par%nt,ig)=0.0
    csg_calc(ishift+par%n_taper+1:par%nt,ig)=0.0

    !! Find the first non-zero element in each trace
    !! ---------------------------------------------
    indx_obs=minloc(abs(csg_obs(:,ig)),1,mask=abs(csg_obs(:,ig)).gt.0)
    indx_obs(1)=indx_obs(1)+50
    tmp=par%n_taper
    do it=indx_obs(1)+401+1,indx_obs(1)+401+par%n_taper
        csg_obs(it,ig)=csg_obs(it,ig)*taper(tmp);
        tmp=tmp-1;
    enddo
    csg_obs(indx_obs(1)+401+par%n_taper+1:par%nt,ig)=0.0

    indx_calc=minloc(abs(csg_calc(:,ig)),1,mask=abs(csg_calc(:,ig)).gt.0)
    indx_calc(1)=indx_calc(1)+50
    tmp=par%n_taper
    do it=indx_calc(1)+401+1,indx_calc(1)+401+par%n_taper
        csg_calc(it,ig)=csg_calc(it,ig)*taper(tmp);
        tmp=tmp-1;
    enddo
    csg_calc(indx_calc(1)+401+par%n_taper+1:par%nt,ig)=0.0

 enddo

 call filename(output,'CSG_OUT/csg_mute_obs',is,'.H@')
 call write_binfile(output,csg_obs,par%nt,coord%ng(is))

 call filename(output,'CSG_OUT/csg_mute_calc',is,'.H@')
 call write_binfile(output,csg_calc,par%nt,coord%ng(is))

 !! Read the frequency shifts from the previous iteration
 !! -----------------------------------------------------
 if(par%iter.gt.1) then
    call filename(output,'CSG_OUT/delta',is,'_iter')
    call filename(output,output,par%iter-1,'.H@')
    call read_binfile(output,delta_f_iter1,coord%ng(is))
 endif

 !! Find the peak frequencies of the observed and the predicted data
 !! ----------------------------------------------------------------
 do ig=1,coord%ng(is)
     trace_obs=csg_obs(:,ig)
     trace_calc=csg_calc(:,ig)

     if(par%normalize.eq.1) then
        trace_obs=trace_obs/max_abs(trace_obs,par%nt)
        trace_calc=trace_calc/max_abs(trace_calc,par%nt)
     endif

     !! Convert the real array into complex
     !! -----------------------------------
     do it=1,par%nt
        trace_obs_complex(it)=cmplx(trace_obs(it),0.0)
        trace_calc_complex(it)=cmplx(trace_calc(it),0.0)
     enddo    

     !! Forward Fourier transform of the data
     !! -------------------------------------
     call dfftw_plan_dft_1d(plan,par%nt,trace_obs_complex,trace_obs_fft,FFTW_FORWARD,FFTW_ESTIMATE)
     call dfftw_execute(plan)
     call dfftw_destroy_plan(plan)

     call dfftw_plan_dft_1d(plan,par%nt,trace_calc_complex,trace_calc_fft,FFTW_FORWARD,FFTW_ESTIMATE)
     call dfftw_execute(plan)
     call dfftw_destroy_plan(plan)

     if(par%method.eq.1) then       !! Use peak frequency to find the frequency shift

        !! Find peak frequencies of the observed and the predicted data
        !! ------------------------------------------------------------
        indx_obs=maxloc(abs(trace_obs_fft(1:par%nt/2+1)))
        fpeak_obs_data=freq(indx_obs(1))

        indx_calc=maxloc(abs(trace_calc_fft(1:par%nt/2+1)))
        fpeak_calc_data=freq(indx_calc(1))

        !! Find delta f
        !! ------------
        delta_f(ig)=fpeak_calc_data-fpeak_obs_data
        if(delta_f(ig).lt.0.0) delta_f(ig)=0.0
        if(par%iter.eq.1) delta_f_iter1(ig)=delta_f(ig)
        if(par%iter.gt.1 .and. abs(delta_f(ig)).gt.abs(delta_f_iter1(ig))) then
            delta_f(ig)=delta_f_iter1(ig)
        endif

    else        !! Use the centroid frequency to find the frequency shift

        trace_obs_fft_abs=abs(trace_obs_fft(1:par%nt/2+1)); trace_calc_fft_abs=abs(trace_calc_fft(1:par%nt/2+1))

        x2=0.0; y2=0.0; x3=0.0; y3=0.0;
        do it=1,par%nt/2+1
           x2=x2+freq(it)*trace_obs_fft_abs(it)
           y2=y2+trace_obs_fft_abs(it)
           x3=x3+freq(it)*trace_calc_fft_abs(it)
           y3=y3+trace_calc_fft_abs(it)
        enddo

        fpeak_obs_data=x2/y2; fpeak_calc_data=x3/y3;    !! Find the centroid frequencies of the observed and the predicted data
        !! Find delta f
        !! ------------
        delta_f(ig)=fpeak_calc_data-fpeak_obs_data
        if(delta_f(ig).lt.0.0) delta_f(ig)=0.0
        if(par%iter.eq.1) delta_f_iter1(ig)=delta_f(ig)
        if(par%iter.gt.1 .and. abs(delta_f(ig)).gt.abs(delta_f_iter1(ig))) then
            delta_f(ig)=delta_f_iter1(ig)
        endif
    endif

 enddo  !! End of receivers loop for a shot

 call filename(output,'CSG_OUT/delta',is,'_iter')
 call filename(output,output,par%iter,'.H@')
 call write_binfile(output,delta_f_iter1,coord%ng(is))

 !! Compute the residual
 !! --------------------
 do ig=1,coord%ng(is)
    residual=residual+delta_f(ig)*delta_f(ig)    
 enddo

 !! Compute weighted residual for backpropagating
 !! ---------------------------------------------
 do ig=1,coord%ng(is)
    csg_mod(:,ig)=csg_obs(:,ig)*delta_f(ig)
 enddo

 !! Save weighted residual
 !! ----------------------
 call filename(output,par%residualfile,is,'_iter')
 call filename(output,output,par%iter,'.H@')
 call write_binfile(output,csg_mod,par%nt,coord%ng(is))

 !! Backpropagate the weighted residual
 !! -----------------------------------
 call atten_rtm_wq(is,par,coord,s,v,den,fs,nx_pml,nz_pml,npml,wave,qf, &
                   tau,tausigma,tauepsilon,csg_mod,energy,gk)

 999 continue
 deallocate(csg_obs,csg_calc,csg_mod,delta_f,wave,delta_f_iter1)
 deallocate(trace_obs,trace_calc,trace_obs_complex,trace_calc_complex)
 if(par%method.eq.2) then
    deallocate(trace_obs_fft_abs,trace_calc_fft_abs)
 endif
 deallocate(trace_obs_fft,trace_calc_fft)
 deallocate(freq,taper)

end subroutine compute_gradient_shot_wq_ssp

!!-------------------------------------------------------------------------
subroutine wq_step_length_atten_ssp(coord,par,is,nx_pml,nz_pml,fs,s,damp, &
                                tau,tausigma,tauepsilon,d,c,qf,den)

 type(acquisition), intent(in)   :: coord
 type(param),       intent(inout):: par
 integer,           intent(in)   :: is,nx_pml,nz_pml,fs(:)
 real,              intent(in)   :: s(:),damp(:,:),d(:,:),qf(:,:),den(:,:),c(:,:)
 real,              intent(inout):: tau(nz_pml,nx_pml),tausigma(nz_pml,nx_pml),tauepsilon(nz_pml,nx_pml)

 allocate(tau_trial(nz_pml,nx_pml))

 !! Use backtracking line search
 !! ----------------------------
    par%alpha_wq=par%step
    nsearch=0
    step_min=par%alpha_wq
    res_min=par%res_new

    100 continue
    call update_tau_ssp(par,npml,tau,par%alpha_wq*d/par%perc_grad,tau_trial) 

    !$omp parallel do private(ix,iz)
    do ix=1,nx_pml
    do iz=1,nz_pml
        tau(iz,ix)=tau_trial(iz,ix)
    enddo
    enddo
    !$omp end parallel do

    if(rank.eq.0) call write_binfile('check_tau.H@',tau(par%npml+1:par%npml+par%nz,par%npml+1:par%npml+par%nx),par%nz,par%nx)

    !! Do FD modeling using the trial tau model
    !! ----------------------------------------
    y2=0.0
    call modeling_step_length_atten_wq_ssp(coord,par,nx_pml,nz_pml,fs,c,qf,den,s,damp, &
                                           tau,tausigma,tauepsilon,y2)
    if (rank.eq.0) then
        write(*,*) "step= ", par%alpha_wq, ", res = ",y2
        call flush(6)
    endif

    if(y2.gt.par%res_new) then
        par%alpha_wq=par%alpha_wq/2.0
        nsearch=nsearch+1
        if(nsearch.gt.par%nsearch_max) then
            !par%step=par%step*0.5
            goto 200
        endif
        goto 100
    endif

    200 continue
    if (nsearch.gt.par%nsearch_max) then
        call update_tau_ssp(par,npml,tau,step_min*d/par%perc_grad,tau_trial) 
        !$omp parallel do private(ix,iz)
        do ix=1,nx_pml
        do iz=1,nz_pml
            tau(iz,ix)=tau_trial(iz,ix)
        enddo
        enddo
        !$omp end parallel do
    endif

 999 continue 
 deallocate(tau_trial)

end subroutine wq_step_length_atten_ssp

!-----------------------------------------------------------------------------------------
subroutine modeling_step_length_atten_wq_ssp(coord,par,nx_pml,nz_pml,fs,v,qf,den,s,damp, &
                                         tau,tausigma,tauepsilon,res)

 type(acquisition), intent(in)   :: coord
 type(param),    intent(inout)   :: par
 integer,           intent(in)   :: nx_pml,nz_pml,fs(:)
 real,              intent(in)   :: v(:,:),s(:),damp(:,:),qf(:,:),den(:,:), &
                                    tau(:,:),tausigma(:,:),tauepsilon(:,:)
 real,              intent(out)  :: res
 integer                         :: is,is1,is2,ishift,tmp,isx,isz

 !! Initialize the output
 !! ---------------------
 res=0.0

 !! Allocate and initialize the variables
 !! -------------------------------------
 allocate(trace_obs(par%nt),trace_calc(par%nt),trace_obs_complex(par%nt),trace_calc_complex(par%nt))
 allocate(trace_obs_fft(par%nt),trace_calc_fft(par%nt)) 
 allocate(freq(par%nt/2+1),taper(par%n_taper))
 if(par%method.eq.2) then
    allocate(trace_obs_fft_abs(par%nt/2+1),trace_calc_fft_abs(par%nt/2+1))
 endif

 trace_obs=0.0; trace_calc=0.0;
 trace_obs_complex=cmplx(0.0,0.0); trace_calc_complex=cmplx(0.0,0.0)
 trace_obs_fft=cmplx(0.0,0.0); trace_calc_fft=cmplx(0.0,0.0)
 if(par%method.eq.2) then
    trace_obs_fft_abs=0.0; trace_calc_fft_abs=0.0;
 endif
 freq=0.0; taper=0.0;

 !! Set up frequency sampling
 !! -------------------------
 do it=1,par%nt/2+1
     freq(it)=(it-1)*1.0/par%dt/par%nt
 enddo

 !! Set up taper for muting the direct-arrivals
 !! -------------------------------------------
 par%n_taper=50 
 call hanning(taper,par%n_taper)

 call MPI_BARRIER(MPI_COMM_WORLD,ierr)
 call get_assigned(par%first_shot,par%last_shot,is1,is2)

 res_process=0.0
 do is=is1,is2,par%skipshot+1

    allocate(csg_obs(par%nt,coord%ng(is)),csg_calc(par%nt,coord%ng(is)))
    allocate(delta_f(coord%ng(is)),delta_f_iter1(coord%ng(is)))
    csg_obs=0.0; csg_calc=0.0; delta_f=0.0; delta_f_iter1=0.0

    call atten_modeling_wq(is,par,coord,s,v,den,fs,nx_pml,nz_pml,npml,qf, &
                           tau,tausigma,tauepsilon,.false.,wave,csg_calc)

    !! Read the observed data
    !! ----------------------
    call filename(output,par%csg_in,is,'.H@')
    call read_binfile(output,csg_obs,par%nt,coord%ng(is))

    !! Mute all the events below the direct arrival
    !! --------------------------------------------
    isx = par%npml+int(coord%xs(is)/par%dx)+1
    isz = par%npml+int(coord%zs(is)/par%dx)+1

    do ig=1,coord%ng(is)

        !! Mute all the events below the direct arrival
        !! --------------------------------------------
        distance=(coord%xs(is)-coord%xg(is,ig))**2+(coord%zs(is)-coord%zg(is,ig))**2
        t_shift=sqrt(distance)/v(isz,isx) 
        ishift=int(t_shift/par%dt)
        tmp=par%n_taper
        do it=ishift+1,ishift+par%n_taper
            csg_obs(it,ig)=csg_obs(it,ig)*taper(tmp)
            csg_calc(it,ig)=csg_calc(it,ig)*taper(tmp)
            tmp=tmp-1
        enddo
        csg_obs(ishift+par%n_taper+1:par%nt,ig)=0.0
        csg_calc(ishift+par%n_taper+1:par%nt,ig)=0.0

        !! Find the first non-zero element in each trace
        !! ---------------------------------------------
        indx_obs=minloc(abs(csg_obs(:,ig)),1,mask=abs(csg_obs(:,ig)).gt.0)
        indx_obs(1)=indx_obs(1)+50
        tmp=par%n_taper
        do it=indx_obs(1)+401+1,indx_obs(1)+401+par%n_taper
            csg_obs(it,ig)=csg_obs(it,ig)*taper(tmp)
            tmp=tmp-1
        enddo
        csg_obs(indx_obs(1)+401+par%n_taper+1:par%nt,ig)=0.0

        indx_calc=minloc(abs(csg_calc(:,ig)),1,mask=abs(csg_calc(:,ig)).gt.0)
        indx_calc(1)=indx_calc(1)+50
        tmp=par%n_taper
        do it=indx_calc(1)+401+1,indx_calc(1)+401+par%n_taper
            csg_calc(it,ig)=csg_calc(it,ig)*taper(tmp)
            tmp=tmp-1
        enddo
        csg_calc(indx_calc(1)+401+par%n_taper+1:par%nt,ig)=0.0
    enddo

    !! Read the frequency shifts from the present iteration
    !! ----------------------------------------------------
    call filename(output,'CSG_OUT/delta',is,'_iter')
    call filename(output,output,par%iter,'.H@')
    call read_binfile(output,delta_f_iter1,coord%ng(is))


    !! Find the peak frequencies of the observed and the predicted data
    !! ----------------------------------------------------------------
    do ig=1,coord%ng(is)
        trace_obs=csg_obs(:,ig)
        trace_calc=csg_calc(:,ig)

        if(par%normalize.eq.1) then
            trace_obs=trace_obs/max_abs(trace_obs,par%nt)
            trace_calc=trace_calc/max_abs(trace_calc,par%nt)
        endif

        !! Convert the real array into complex
        !! -----------------------------------
        do it=1,par%nt
            trace_obs_complex(it)=cmplx(trace_obs(it),0.0)
            trace_calc_complex(it)=cmplx(trace_calc(it),0.0)
        enddo    

        !! Forward Fourier transform of the data
        !! -------------------------------------
        call dfftw_plan_dft_1d(plan,par%nt,trace_obs_complex,trace_obs_fft,FFTW_FORWARD,FFTW_ESTIMATE)
        call dfftw_execute(plan)
        call dfftw_destroy_plan(plan)

        call dfftw_plan_dft_1d(plan,par%nt,trace_calc_complex,trace_calc_fft,FFTW_FORWARD,FFTW_ESTIMATE)
        call dfftw_execute(plan)
        call dfftw_destroy_plan(plan)

        if(par%method.eq.1) then        !! Use peak frequency to find the frequency shift
            
            !! Find peak frequencies of the observed and the predicted data
            !! ------------------------------------------------------------
            indx_obs=maxloc(abs(trace_obs_fft(1:par%nt/2+1)))
            fpeak_obs_data=freq(indx_obs(1))

            indx_calc=maxloc(abs(trace_calc_fft(1:par%nt/2+1)))
            fpeak_calc_data=freq(indx_calc(1))

            !! Find delta f (Check this step)
            !! ------------------------------
            delta_f(ig)=fpeak_calc_data-fpeak_obs_data
            if(delta_f(ig).lt.0.0) delta_f(ig)=0.0
            if(par%iter.gt.1 .and.abs(delta_f(ig)).gt.abs(delta_f_iter1(ig))) then
                delta_f(ig)=delta_f_iter1(ig)
            endif

        else    !! Use the centroid frequency to find the frequency shift

            trace_obs_fft_abs=abs(trace_obs_fft(1:par%nt/2+1)); trace_calc_fft_abs=abs(trace_calc_fft(1:par%nt/2+1))

            x2=0.0; y2=0.0; x3=0.0; y3=0.0;
            do it=1,par%nt/2+1
                x2=x2+freq(it)*trace_obs_fft_abs(it)
                y2=y2+trace_obs_fft_abs(it)
                x3=x3+freq(it)*trace_calc_fft_abs(it)
                y3=y3+trace_calc_fft_abs(it)
            enddo

            fpeak_obs_data=x2/y2; fpeak_calc_data=x3/y3;    !! Find the centroid frequencies of the observed and the predicted data
            !! Find delta f
            !! ------------
            delta_f(ig)=fpeak_calc_data-fpeak_obs_data
            if(delta_f(ig).lt.0.0) delta_f(ig)=0.0
            if(par%iter.eq.1) delta_f_iter1(ig)=delta_f(ig)
            if(par%iter.gt.1 .and. abs(delta_f(ig)).gt.abs(delta_f_iter1(ig))) then
                delta_f(ig)=delta_f_iter1(ig)
            endif
        endif
    enddo

    !! Compute the residual
    !! --------------------
    do ig=1,coord%ng(is)
        res_process=res_process+delta_f(ig)*delta_f(ig)    
    enddo

    deallocate(csg_obs,csg_calc,delta_f,delta_f_iter1)
 enddo

 call MPI_BARRIER(MPI_COMM_WORLD,ierr)
 call MPI_Allreduce(res_process,res,1,MPI_REAL,MPI_SUM,MPI_COMM_WORLD,ierr)

 999 continue
 deallocate(trace_obs,trace_calc,trace_obs_complex,trace_calc_complex)
 deallocate(trace_obs_fft,trace_calc_fft)
  if(par%method.eq.2) then
    deallocate(trace_obs_fft_abs,trace_calc_fft_abs)
 endif
 deallocate(freq,taper)

end subroutine modeling_step_length_atten_wq_ssp

!!--------------------------------------------------
subroutine update_tau_ssp(par,npml,tau,dtau,tau_new)

 use datatype
 use global
 use io

 type(param), intent(in) :: par
 real, intent(in)        :: tau(:,:), dtau(:,:)
 real, intent(out)       :: tau_new(:,:)
 integer, intent(in)     :: npml
 integer                 :: ix1, ix2, iz1, iz2, nx_pml, nz_pml, i, j
 real                    :: tau_old_min, tau_old_max

 nx_pml = par%nx + 2*npml
 nz_pml = par%nz + 2*npml
 ix1 = npml+1
 ix2 = nx_pml-npml
 iz1 = npml+1
 iz2 = nz_pml-npml

 tau_new(iz1:iz2,ix1:ix2) = tau(iz1:iz2,ix1:ix2) + dtau
 if (par%tau_constraint > 0.0) then
    do i=1,par%nx
    do j=1,par%nz
      tau_old_min = tau(npml+j,npml+i)*(1.0-par%tau_constraint/100.0)
      tau_old_max = tau(npml+j,npml+i)*(1.0+par%tau_constraint/100.0)
      if (tau_new(npml+j,npml+i) > tau_old_max) tau_new(npml+j,npml+i) = tau_old_max
      if (tau_new(npml+j,npml+i) < tau_old_min) tau_new(npml+j,npml+i) = tau_old_min
    enddo
    enddo
 endif

  do i=1,par%nx
  do j=1,par%nz
    if (tau_new(npml+j,npml+i) < par%tau_min) tau_new(npml+j,npml+i) = par%tau_min
    if (tau_new(npml+j,npml+i) > par%tau_max) tau_new(npml+j,npml+i) = par%tau_max
  enddo
  enddo

 ! Extrapolate tau in PML regions
 do i=1,npml
    tau_new(iz1:iz2,i) = tau_new(iz1:iz2,npml+1)
    tau_new(iz1:iz2,ix2+i) = tau_new(iz1:iz2,nx_pml-npml)
 enddo
 do i=1,npml
    tau_new(i,:) = tau_new(npml+1,:)
    tau_new(iz2+i,:) = tau_new(nz_pml-npml,:)
 enddo

 if (par%smooth_tau > 0) then
    call smooth(tau_new, nz_pml, nx_pml, par%smooth_tau)
 endif

end subroutine update_tau_ssp

!!------------------------------------------
subroutine update_q(par,nz_pml,nx_pml,tau,qf)

 use global
 use datatype 

 type(param), intent(in)  :: par
 integer, intent(in)      :: nz_pml,nx_pml
 real,    intent(in)      :: tau(:,:)
 real,    intent(inout)   :: qf(:,:)

 real, allocatable        :: q(:),tau_ref(:),tausigma(:),tauepsilon(:)
 integer                  :: i,n,idx
 real                     :: tmp
 
 n=(10000-20)/0.01+1      ! 10000 = max Q value
                          ! 20 = min Q value

 allocate(q(n),tau_ref(n),tausigma(n),tauepsilon(n))
 q=0.0; tau_ref=0.0; tausigma=0.0; tauepsilon=0.0

 do i=1,n
    q(i)=20.0+(i-1)*0.01        
    tausigma(i)=(sqrt(1.0+1.0/q(i)/q(i))-1.0/q(i))/(2.0*pi*par%f)
    tauepsilon(i)=1.0/(2.0*pi*par%f)/(2.0*pi*par%f)/tausigma(i)
    tau_ref(i)=tauepsilon(i)/tausigma(i)-1.0
 enddo

 !$omp parallel do private(iz,ix,tmp,i,idx)
 do ix=1,nx_pml
 do iz=1,nz_pml
    tmp=tau(iz,ix);
    do i=1,n
        if(abs(tau_ref(i)-tmp)<0.01) then
            idx=i
            exit
        endif
    enddo
    qf(iz,ix)=q(idx);
 enddo
 enddo
 !$omp end parallel do

 deallocate(q,tau_ref,tausigma,tauepsilon)

end subroutine update_q
!----------------------



end module wq_utilities_atten_ssp
