!  Copyright (C) 2011 Center for Subsurface Imaging and Fluid Modeling (CSIM),
!  King Abdullah University of Science and Technology, All rights reserved.

!  file:       distance
!  purpose:    calculate of distance matrix from each model grid
!              to each s/r location,This matrix is used for 
!              geometric spreading/obliquity factor/energyloss., etc. 
!  output:     distance ------ 3 dimensional distance table 

!  author:   Wei Dai & Xin Wang
!  email:    xin.wang@kaust.edu.sa
!  date:     Oct 21, 2011

subroutine dist_cal(distance)
include "lsm2d_parameters.par"
real,intent(out) :: distance(nz,nx,ns)
integer          :: i1,i2,i3

do i3=1,ns
   do i2=1,nx
      do i1=1,nz
         distance(i1,i2,i3)=sqrt((dx*(i2-1)-ds*(i3-1))**2+(dz*i1)**2)
      enddo
   enddo
enddo

end subroutine dist_cal
