% Define the directory
model_dir='./model/marmousi2_151_401_10m';
results_dir='./results/marmousi2_151_401_10m';

% Load the true velocity model
load([model_dir,'/vel.mat']);

% load the initial velocity model
load([model_dir,'/v1.mat']);

% read the final velocity model
v_final=read_bin([results_dir,'/vel_10.bin'],nz,nx);
% load the misfit convergence
load([results_dir,'/misfit.mat']);

x=0:dx:(nx-1)*dx;z=0:dx:(nz-1)*dx;
figure;
subplot(221);imagesc(x,z,vel);xlabel('X (m)');ylabel('Z (m)');title('True velocity');
subplot(222);imagesc(x,z,vel0);xlabel('X (m)');ylabel('Z (m)');title('Initial velocity');
subplot(223);imagesc(x,z,v_final);xlabel('X (m)');ylabel('Z (m)');title('Final velocity');
subplot(224);plot(0:numel(misfit)-1,misfit/misfit(1),'-b*');xlabel('Iteration number');
ylabel('Normalized misfit functional');title('Convergence curve');


